---
Note type: Reference
tags:
  - ZoteroReference
  - REFERENCE
Reference type: "book"
Bib_ref: "Birkinbine BJ (2020) _Incorporating the Digital Commons: Corporate Involvement in Free and Open Source Software_. University of Westminster Press. Available at: [https://uwestminsterpress.co.uk/site/books/m/10.16997/book39/](https://uwestminsterpress.co.uk/site/books/m/10.16997/book39/) (accessed 4 June 2024)."
Title: "Incorporating the Digital Commons: Corporate Involvement in Free and Open Source Software"
Authors: "Benjamin J. Birkinbine"
Year: "2020-02-26T00:00:00+00:00"
Journal-publisher: ""
Read: Read
Related areas:
  - "[[Research]]"
Related projects: 
Related tasks: 
Related references: 
Related zettels: 
Related meeting notes: 
Related resources: 
Related people: 
aliases:
  - '"Incorporating the Digital Commons: Corporate Involvement in Free and Open Source Software"'
Creation date: "2024-06-04T21:21:24+01:00"
---

# Item notes from Zotero

Open in Zotero: [Full Text PDF](zotero://select/library/items/D3HDNGPF)
## Overview

### Context

[Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=2&annotation=9N9KQJU3) “corporate involvement in FLOSS has been increasing, especially since about 2007–2008.” ([Birkinbine, 2020, p. 2](zotero://select/library/items/2M39PEF5))

  
[Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=3&annotation=66NVXKPX)  

#### Relationship between Microsoft and FLOSS movement

- **2001**: Denounced the FLOSS GNU General Public License as “a cancer that attaches itself in an intellectual property sense to everything it touches”
- **2012**:
    
    - [Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=1&annotation=9VLWIMN6) “Microsoft was one of the top 20 contributors to the kernel. This marks the first time that Microsoft appeared as a top contributor, but it was not the only corporation in the top 20. Other corporate contributors included Intel, IBM, Google, Texas Instruments, Cisco, Hewlett-Packard, and Samsung, as well as others” ([Birkinbine, 2020, p. 1](zotero://select/library/items/2M39PEF5))
    - [Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=2&annotation=QMB5IVMB) “That same year, Microsoft created Microsoft Open Technologies, Inc., a wholly owned subsidiary dedicated to facilitating interoperability between Microsoft and non-Microsoft technologies, while promoting open standards and open source. What changed during this 12-year period that Microsoft would so dramatically reposition itself in relation to FLOSS?” ([Birkinbine, 2020, p. 2](zotero://select/library/items/2M39PEF5))

### Aim

### RQ

- **Questions about motivations for corporations:** [Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=1&annotation=HD6RSSNR) “Why {…} would major corporations contribute directly to a FLOSS project, especially when that project seemingly does not directly contribute to corporate profits?” ([Birkinbine, 2020, p. 1](zotero://select/library/items/2M39PEF5))
- **Questions about implications for FLOSS community:**
    
    - [Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=2&annotation=QMYIUR7H) “in what ways are they contributing to FLOSS projects? How do communities of FLOSS developers negotiate corporate involvement in their projects? Do communities of FLOSS developers have any recourse for unwanted corporate involvement or influence in their projects?” ([Birkinbine, 2020, p. 2](zotero://select/library/items/2M39PEF5))
    - How can FLOSS communities “negotiate the relationship between their digital commons and the unwanted intrusion by capital into their projects?” ([Birkinbine, 2020, p. 4](zotero://select/library/items/2M39PEF5))

### Thesis

[Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=3&annotation=W84RUQQQ) “the purportedly revolutionary changes brought about by FLOSS and commons-based peer production are now becoming incorporated into corporate strategies and corporate structures.” ([Birkinbine, 2020, p. 3](zotero://select/library/items/2M39PEF5))

[Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=3&annotation=U7IVQBQR) “The central argument presented here is that free and open source software is dialectically situated between capital and the commons.” ([Birkinbine, 2020, p. 3](zotero://select/library/items/2M39PEF5))

### Theoretical framing

[[critical political economy]]

The [[commons]] (and by extention [[digital commons]]) “can be understood as an **alternative system of value** that is emerging from within [[capitalism]]. At times, circuits of commons value can intersect with capital accumulation circuits. Therefore, understanding the relationship between free software and capital dialectically is useful for accounting for the contradictions between these two forces that operate according to differing logics.” ([Birkinbine, 2020, p. 4](zotero://select/library/items/2M39PEF5))

### Methodology

[[critical political economy]] approach to studying FLOSS-corporate relations:

- [Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=2&annotation=DQ3P3P29) “I investigate the power dynamics that exist between communities of FLOSS developers and the corporations that sponsor FLOSS projects or appropriate the software production of FLOSS labourers.” ([Birkinbine, 2020, p. 2](zotero://select/library/items/2M39PEF5))
- [Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=3&annotation=Z8GWZWAU) “I position technology as a site of social struggle, and I contextualise commons-based peer production within a broader social context to illustrate how such production intersects with capitalist production.” ([Birkinbine, 2020, p. 3](zotero://select/library/items/2M39PEF5))

3 case studies:

- Chapter 3: Shifting Toward the Commons: **Microsoft** and Competing Models of Software Production
- Chapter 4: From the Commons to Capital: **Red Hat, Inc.** and the Incorporation of Free Software
- Chapter 5: Resisting Incorporation and Reclaiming the Commons: The Case of **Oracle** and **Sun Microsystems**

### Findings

### Contributions

- [Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=102&annotation=JNG2QJ8G) “This study complicates and extends theorisations of **commons-based peer production** by investigating sites where the idealism of FLOSS production meets with the material realities of capitalism.” ([Birkinbine, 2020, p. 102](zotero://select/library/items/2M39PEF5))
- [Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=102&annotation=ISA2X9KL) “a novel insight into how **intellectual property** is used both within the FLOSS community and corporations.” ([Birkinbine, 2020, p. 102](zotero://select/library/items/2M39PEF5))
    
    - “the case of Red Hat demonstrated how a firm is able to profit from intellectual property that is covered by the GPL and, therefore, **not amenable to enclosure by traditional copyright.** Because Red Hat cannot exclude others from using its source code by relying on copyright, the company uses its trademarks to prohibit competitors from making a direct use of its products. However, Red Hat’s trademarks cannot prevent someone from using the underlying source code, which is protected by copyleft.” ([Birkinbine, 2020, p. 103](zotero://select/library/items/2M39PEF5))

### Striking points

### Further research suggested

### My ideas/responses

### Useful references

### Structure of the book

- Chapter 1: Introduction: Open Source Software and the Digital Commons
- Chapter 2: Toward a Critical Political Economy of the Digital Commons
- Chapter 3: Shifting Toward the Commons: Microsoft and Competing Models of Software Production
- Chapter 4: From the Commons to Capital: Red Hat, Inc. and the Incorporation of Free Software
- Chapter 5: Resisting Incorporation and Reclaiming the Commons: The Case of Oracle and Sun Microsystems
- Chapter 6: Conclusion: From Capital to Commoning

---

## Fleeting notes

---

## Summary

### Central argument of the book: FLOSS is dialectically situated between capital and the commons

- FLOSS and the commons
    
    - “On the one hand, communities of programmers are actively working to create software as digital commons that can be accessed, used, adapted by others. By developing software iteratively this way, the pace and scale of software production increases. This represents a virtuous cycle whereby an association of software programmers actively contribute to a community that claims collective ownership over FLOSS projects. As such, FLOSS programmers can be framed as commoners insofar as they remain committed to ensuring the reproduction and sustainability of commons-based software projects over time.” ([Birkinbine, 2020, p. 3](zotero://select/library/items/2M39PEF5))
- FLOSS and capital
    
    - “On the other hand, capital attempts to capture the value being produced by FLOSS communities. This includes harnessing the processes (i.e. the collective labour, or commons-based peer production power) involved in FLOSS production as well as commodifying the products (i.e. specific FLOSS projects), which can provide a basis upon which to commercially exploit the collaborative production occurring in FLOSS communities.” ([Birkinbine, 2020, p. 4](zotero://select/library/items/2M39PEF5))
- Mutually-beneficial aspects of the exchange between the two:
    
    - While “the commons and capitalism {operate} according to different systems of value {at} times, these two systems are capable of working together by coupling through the commodity form” i.e. where FLOSS projects are “incorporated into commercial offerings” ([Birkinbine, 2020, p. 102](zotero://select/library/items/2M39PEF5))
    - Benefit for capitalist firms: “innovations and bug fixes from within the FLOSS community” ([Birkinbine, 2020, p. 102](zotero://select/library/items/2M39PEF5))
    - Benefit for the FLOSS communities: [Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=4&annotation=BHBTLJIY) “commercial sponsorship of FLOSS projects tends to make those projects more likely to attract developers and, therefore, ensures the project’s longevity” ([Birkinbine, 2020, p. 4](zotero://select/library/items/2M39PEF5))
- Deleterious aspects of the exchange:
    
    - However, at other times, these systems diverge, which can lead to an antagonistic relationship between capital and the commons.” ([Birkinbine, 2020, p. 102](zotero://select/library/items/2M39PEF5))
    - [Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=4&annotation=A8288TPX) “unwanted encroachment of capital upon commonly held resources like the digital commons.” ([Birkinbine, 2020, p. 4](zotero://select/library/items/2M39PEF5))
    - [Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=4&annotation=4U9YSRX5) “The FLOSS community is faced not only with the challenge of ensuring that their digital commons remain viable, but also with ensuring that the project maintains the sense of community that enabled the project to grow in the first place.” ([Birkinbine, 2020, p. 4](zotero://select/library/items/2M39PEF5))

### GNU General Public License

- [Go to annotation](zotero://open-pdf/library/items/D3HDNGPF?page=1&annotation=YD25JTG9) “the most commonly used free software license.” ([Birkinbine, 2020, p. 1](zotero://select/library/items/2M39PEF5))
- “grants users of GPL-protected software the right to study, use, copy, modify, or adapt the software as they wish.” ([Birkinbine, 2020, p. 1](zotero://select/library/items/2M39PEF5))
- “In addition, users are granted the right to redistribute the software, as well as a modified version, and the user may even charge a fee for the modified version, provided that the distributor does not place greater restrictions on the rights granted by the GPL. The GPL does not preclude corporations from modifying free software or charging a fee for their modified versions, but the corporation must still grant free software rights to end users.” ([Birkinbine, 2020, p. 2](zotero://select/library/items/2M39PEF5))

---

## Miscellaneous points